VERSION 5.00
Begin VB.Form frmOfferService 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "#Offer service item"
   ClientHeight    =   3990
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   15195
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3990
   ScaleWidth      =   15195
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Tag             =   "frmOfferService"
   Visible         =   0   'False
   Begin Project1.A_calocx cal_DeliveryDate 
      Height          =   360
      Left            =   13155
      TabIndex        =   4
      Top             =   150
      Width           =   1845
      _ExtentX        =   3254
      _ExtentY        =   635
   End
   Begin Project1.A_calocx cal_WishDate 
      Height          =   360
      Left            =   6315
      TabIndex        =   2
      Top             =   150
      Width           =   1845
      _ExtentX        =   3254
      _ExtentY        =   635
   End
   Begin Project1.A_calocx cal_ShipDate 
      Height          =   360
      Left            =   9705
      TabIndex        =   3
      Top             =   150
      Width           =   1845
      _ExtentX        =   3254
      _ExtentY        =   635
   End
   Begin VB.CommandButton btn_Quit 
      Height          =   612
      Left            =   14475
      Style           =   1  'Graphical
      TabIndex        =   21
      Tag             =   "btn_Quit"
      Top             =   3300
      Width           =   612
   End
   Begin VB.CommandButton btn_Validate 
      Height          =   612
      Left            =   13800
      Style           =   1  'Graphical
      TabIndex        =   20
      Tag             =   "btn_Validate"
      Top             =   3300
      Width           =   612
   End
   Begin VB.Frame fra_Comment 
      Height          =   1950
      Left            =   30
      TabIndex        =   10
      Tag             =   "fra_Comment"
      Top             =   1095
      Width           =   15090
      Begin VB.TextBox txt_AddText 
         Height          =   315
         Left            =   1560
         MaxLength       =   50
         TabIndex        =   12
         Top             =   585
         Width           =   12600
      End
      Begin VB.TextBox txt_Qty 
         Height          =   315
         Left            =   1560
         TabIndex        =   13
         Top             =   930
         Width           =   1335
      End
      Begin VB.TextBox txt_Price 
         Height          =   315
         Left            =   7260
         TabIndex        =   15
         Top             =   930
         Width           =   1335
      End
      Begin VB.TextBox txt_CURR_CodePrice 
         BackColor       =   &H8000000F&
         Height          =   300
         Left            =   8715
         Locked          =   -1  'True
         TabIndex        =   16
         TabStop         =   0   'False
         Top             =   930
         Width           =   1140
      End
      Begin VB.TextBox txt_Total 
         BackColor       =   &H8000000F&
         Height          =   315
         Left            =   11580
         Locked          =   -1  'True
         TabIndex        =   17
         TabStop         =   0   'False
         Top             =   930
         Width           =   1335
      End
      Begin VB.TextBox txt_CURR_CodeTotal 
         BackColor       =   &H8000000F&
         Height          =   300
         Left            =   13035
         Locked          =   -1  'True
         TabIndex        =   18
         TabStop         =   0   'False
         Top             =   930
         Width           =   1140
      End
      Begin VB.TextBox txt_CURR_CodeCost 
         BackColor       =   &H8000000F&
         Height          =   300
         Left            =   8715
         Locked          =   -1  'True
         TabIndex        =   22
         TabStop         =   0   'False
         Top             =   1260
         Width           =   1140
      End
      Begin VB.TextBox txt_Cost 
         Height          =   315
         Left            =   7260
         TabIndex        =   19
         Top             =   1260
         Width           =   1335
      End
      Begin Project1.ArmCombobox cbo_UOM 
         Height          =   345
         Left            =   3765
         TabIndex        =   14
         Top             =   930
         Width           =   1140
         _ExtentX        =   2011
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_ServiceItem 
         Height          =   345
         Left            =   1560
         TabIndex        =   11
         Tag             =   "cbo_ServiceItem"
         Top             =   210
         Width           =   12630
         _ExtentX        =   22278
         _ExtentY        =   609
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Additional text"
         Height          =   225
         Index           =   8
         Left            =   135
         TabIndex        =   35
         Tag             =   "lbl_AdditionalText"
         Top             =   645
         Width           =   1290
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#UoM"
         Height          =   225
         Index           =   1
         Left            =   2970
         TabIndex        =   34
         Tag             =   "lbl_UoM"
         Top             =   960
         Width           =   780
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Service item"
         Height          =   225
         Index           =   2
         Left            =   135
         TabIndex        =   33
         Tag             =   "lbl_ServiceItem"
         Top             =   300
         Width           =   1290
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Quantity"
         Height          =   225
         Index           =   3
         Left            =   120
         TabIndex        =   32
         Tag             =   "lbl_Quantity"
         Top             =   975
         Width           =   1290
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Price"
         Height          =   225
         Index           =   4
         Left            =   5805
         TabIndex        =   31
         Tag             =   "lbl_Price"
         Top             =   975
         Width           =   1290
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Total"
         Height          =   225
         Index           =   5
         Left            =   10125
         TabIndex        =   30
         Tag             =   "lbl_Total"
         Top             =   975
         Width           =   1290
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Cost"
         Height          =   225
         Index           =   7
         Left            =   5805
         TabIndex        =   29
         Tag             =   "lbl_Cost"
         Top             =   1305
         Width           =   1290
      End
   End
   Begin VB.TextBox txt_OFD_Pos 
      Height          =   375
      Left            =   3855
      TabIndex        =   1
      Top             =   165
      Width           =   810
   End
   Begin VB.TextBox txt_Code 
      Height          =   375
      Left            =   1275
      TabIndex        =   0
      Top             =   165
      Width           =   1500
   End
   Begin VB.CheckBox chk_ASFlag 
      Caption         =   "#AS Item"
      Height          =   225
      Left            =   9780
      TabIndex        =   7
      Tag             =   "chk_ASFlag"
      Top             =   690
      Width           =   1500
   End
   Begin VB.CheckBox chk_FreeOfCharge 
      Caption         =   "#Free of charge"
      Height          =   225
      Left            =   11445
      TabIndex        =   9
      Tag             =   "chk_FreeOfCharge"
      Top             =   675
      Width           =   1755
   End
   Begin Project1.ArmCombobox cbo_Vendor 
      Height          =   345
      Left            =   1290
      TabIndex        =   5
      Top             =   615
      Width           =   2565
      _ExtentX        =   4524
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_ShipPoint 
      Height          =   345
      Left            =   6315
      TabIndex        =   6
      Top             =   615
      Width           =   2865
      _ExtentX        =   5054
      _ExtentY        =   609
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Position"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   238
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   225
      Index           =   0
      Left            =   2790
      TabIndex        =   28
      Tag             =   "lbl_Position"
      Top             =   240
      Width           =   1035
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Delivery date"
      Height          =   255
      Index           =   6
      Left            =   11625
      TabIndex        =   27
      Tag             =   "lbl_OFD_DeliveryDate"
      Top             =   210
      Width           =   1500
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Wish date"
      Height          =   255
      Index           =   185
      Left            =   4800
      TabIndex        =   26
      Tag             =   "lbl_OFD_WishDate"
      Top             =   210
      Width           =   1470
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Shipping point"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   238
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Index           =   30
      Left            =   4800
      TabIndex        =   25
      Tag             =   "lbl_ShipPoint"
      Top             =   660
      Width           =   1470
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Plant/Vendor"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   238
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Index           =   11
      Left            =   0
      TabIndex        =   24
      Tag             =   "lbl_PlantVendor"
      Top             =   660
      Width           =   1275
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Code"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   238
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   225
      Index           =   9
      Left            =   15
      TabIndex        =   23
      Tag             =   "lbl_Code"
      Top             =   240
      Width           =   1200
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Ship date"
      Height          =   255
      Index           =   10
      Left            =   8235
      TabIndex        =   8
      Tag             =   "lbl_OFD_ShipDate"
      Top             =   210
      Width           =   1470
   End
End
Attribute VB_Name = "frmOfferService"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "frmOfferService"

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private me_PriceBookType                As eDPCPriceBookType
Private ml_U_Code                       As Long
Private ms_Language_Code                As String
Private ms_COF_Lang                     As String       'current user data language
Private mc_ScreenLabels                 As Long
Private mb_InternalInit                 As Boolean
Private mb_Initialized                  As Boolean
Private mo_Tools                        As DPC_Tools

#If ENV = LIVE Then
Private mo_Db As Object
Private mo_FSO As Object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_FSO As FileSystemObject
#End If

Public Result As Boolean
Public CURR_Code As String
Public PRD_Code As String
Public CT_Code As String
Public COF_Id As String
Public LEN_Id As String
Public OFD_WshDat As Date
Public OFD_ShpDat As Date
Public OFD_DelDat As Date
Public OFD_Pos As Long
Public SAE_Id As Long
Public SHP_Id As Long
Public VEN_Id As String
Public SAE_Name As String
Public SHP_Name As String
Public VEN_Name As String
Public IsAsItem As Boolean
Public IsFree As Boolean

Public OFD_MarginS As Double
Public OFD_GTN As Double
Public OFD_MarginMin As Double

Public OfferPrice As New Collection

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Property Let U_Code(al_Code As Long)
  ml_U_Code = al_Code
End Property

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Property Let COF_Lang(as_Value As String)
On Error GoTo ErrHandler

  ms_COF_Lang = as_Value
  Exit Property
ErrHandler:
  Call ErrorMessage("COF_Lang.Let")
End Property

Public Property Get Initialized() As Boolean
On Error GoTo ErrHandler
    
  Initialized = mb_Initialized
  Exit Property
ErrHandler:
  Call ErrorHandler("Initialized.Get")
End Property

Public Function Load_A_COM() As Boolean
On Error GoTo ErrHandler

  Dim ls_req As String
  Dim ll_Idx As Long
  
  Load_A_COM = False
  
  If mb_Initialized Then
      Call Err.Raise(ArmErr.CPTAlreadyInitialized)
  End If
  
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  mb_InternalInit = True
  Call mo_Tools.Load_A_ComControls(Me.Controls, mo_Db, ms_Language_Code)
  
  btn_Validate.Picture = LoadResPicture(RES_OK, 1)
  btn_Quit.Picture = LoadResPicture(RES_QUIT, 1)
  
  Set mo_FSO = New FileSystemObject

  ls_req = "exec DPC_Unit_Of_Measure_cbo2 $COF_Lang$"
  ls_req = ReplaceCommonPlaceholders(ls_req)
  cbo_UOM.Request = ls_req
  Call cbo_UOM.Load
  
  ls_req = "exec DPC_Surcharge_cbo $COF_Lang$"
  ls_req = ReplaceCommonPlaceholders(ls_req)
  cbo_ServiceItem.Request = ls_req
  
  Call InitVendorCombo(cbo_Vendor)
  Call InitShipPointCombo(cbo_ShipPoint)

  Call mo_Tools.EnableControl(txt_Code, False)
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, gl_CodePage, mo_Tools.GetCodePageFromLanguage(mo_Db, ms_COF_Lang), Me)
  Result = False
  mb_InternalInit = False
  mb_Initialized = True
  Load_A_COM = mb_Initialized
  Exit Function
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Function

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Db = Nothing
  Set mo_FSO = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub

Public Sub ItemAdd()
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim lo_Offer As DPC_OfferPos

  mb_InternalInit = True
  Set lo_Offer = New DPC_OfferPos
  Set lo_Offer.Tools = mo_Tools
  Call lo_Offer.Init(0, 0, eDPCQtyType.qtPCS, 1, 0, 0)
  Call OfferPrice.Add(lo_Offer)
  Call LoadSystemMargin
  
  Call DisplayHeader
  txt_CURR_CodePrice.Text = CURR_Code
  txt_CURR_CodeCost.Text = CURR_Code
  txt_CURR_CodeTotal.Text = CURR_Code
  mb_InternalInit = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("ItemAdd")
End Sub

Public Sub ItemUpdate(ByVal as_COF_Id As String, ByVal as_OFD_IdPar As String)
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ls_PRD_Name  As String, ls_DOF_Value As String, ls_DOF_Name As String
Dim ll_Idx As Long, ll_RowIndex As Long, ll_Order As Long
Dim lo_Offer As DPC_OfferPos
Dim ls_ServiceName As String, ls_AddText As String
Dim ll_SepPos As Long

  mb_InternalInit = True
  ls_req = "exec Cap_OfferDetail_lst2 $COF_Id$, $COF_Lang$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", mo_Tools.SqlInt(eDPCOfferDetailMain.odMain), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IdPar$", mo_Tools.SQLStr(as_OFD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", "NULL", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) > 0 Then
    Set lo_Offer = New DPC_OfferPos
    Set lo_Offer.Tools = mo_Tools
    Call lo_Offer.Init(0, 0, eDPCQtyType.qtPCS, 1, 0, 0)
    Call lo_Offer.ReadOfferPos(mo_Db, lc_Cursor)
    Call OfferPrice.Add(lo_Offer)
  End If
  Call mo_Db.Close(lc_Cursor)
  
  ll_SepPos = InStr(1, lo_Offer.PRD_Name, ":")
  If ll_SepPos = 0 Then
    ls_ServiceName = lo_Offer.PRD_Name
    ls_AddText = ""
  Else
    ls_ServiceName = Left(lo_Offer.PRD_Name, ll_SepPos - 1)
    ls_AddText = right(lo_Offer.PRD_Name, Len(lo_Offer.PRD_Name) - ll_SepPos - 1)
  End If
  
  Call cbo_ServiceItem.AddItem(Array(lo_Offer.PRD_Id, ls_ServiceName), True)
  txt_AddText.Text = ls_AddText
  
  txt_Qty.Text = mo_Tools.DblToScreen(lo_Offer.OFD_Qty)
  Call cbo_UOM.SearchItem(lo_Offer.UM_Code)
  
  VEN_Id = lo_Offer.VEN_Id
  VEN_Name = lo_Offer.VEN_Name
  
  SHP_Id = lo_Offer.SHP_Id
  SHP_Name = lo_Offer.SHP_Name
  OFD_MarginMin = lo_Offer.OFD_MarginMin
  OFD_MarginS = lo_Offer.OFD_MarginS
  OFD_GTN = lo_Offer.OFD_GTN
  
  txt_Price.Text = mo_Tools.DblToScreen(lo_Offer.OFD_Price)
  txt_Total.Text = mo_Tools.DblToScreen(lo_Offer.OFD_TotalP)
  txt_Cost.Text = mo_Tools.DblToScreen(lo_Offer.OFD_Cost)
  
  txt_CURR_CodePrice.Text = CURR_Code
  txt_CURR_CodeCost.Text = CURR_Code
  txt_CURR_CodeTotal.Text = CURR_Code
  Call DisplayHeader
  mb_InternalInit = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("ItemUpdate")
End Sub

Private Sub LoadSystemMargin()
On Error GoTo ErrHandler
  
Dim ls_req As String
Dim lc_Cursor As Long
  
  OFD_MarginS = 0
  OFD_GTN = 0
  OFD_MarginMin = 0
  ls_req = "exec DPC_SysMargin_sel $CT_Code$, $Language_Code$"
  ls_req = Replace(ls_req, "$CT_Code$", mo_Tools.SQLStr(CT_Code), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    OFD_MarginS = mo_Db.GetFields(lc_Cursor, "SMA_PanMargin")
    OFD_GTN = mo_Db.GetFields(lc_Cursor, "SMA_PanGTN")
    OFD_MarginMin = mo_Db.GetFields(lc_Cursor, "SMA_PanMin")
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadSystemMargin")
End Sub

Private Sub InitVendorCombo(ByVal ao_Combo As ArmCombobox)
On Error GoTo ErrHandler

  Dim ls_Request As String
  ls_Request = "exec DPC_Vendor_SAP_View_lst $LEN_Id$, $COF_Lang$"
  ls_Request = Replace(ls_Request, "$LEN_Id$", mo_Tools.SqlInt(LEN_Id), , , vbTextCompare)
  ls_Request = ReplaceCommonPlaceholders(ls_Request)
  ao_Combo.Request = ls_Request
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitVendorCombo")
End Sub

Private Sub InitShipPointCombo(ByVal ao_Combo As ArmCombobox)
On Error GoTo ErrHandler

  Dim ls_Request As String
  ls_Request = "exec DPC_ShipPoint_SAP_View_lst $LEN_Id$, $VEN_Id$, $COF_Lang$"
  ls_Request = Replace(ls_Request, "$LEN_Id$", mo_Tools.SqlInt(LEN_Id), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$VEN_Id$", mo_Tools.SQLStr(mo_Tools.GetComboKey(cbo_Vendor)), , , vbTextCompare)
  ls_Request = ReplaceCommonPlaceholders(ls_Request)
  ao_Combo.Request = ls_Request
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitShipPointCombo")
End Sub

Private Sub DisplayHeader()
On Error GoTo ErrHandler
  
  txt_OFD_Pos.Text = mo_Tools.LongToScreen(OFD_Pos)
  Call mo_Tools.EnableControl(txt_OFD_Pos, False)
  
  Call mo_Tools.SetCalendarDate(cal_WishDate, OFD_WshDat)
  Call mo_Tools.SetCalendarDate(cal_ShipDate, OFD_ShpDat)
  Call mo_Tools.SetCalendarDate(cal_DeliveryDate, OFD_DelDat)
  txt_Code.Text = PRD_Code
  
  Call InitVendorCombo(cbo_Vendor)
  Call InitShipPointCombo(cbo_ShipPoint)
  If Not cbo_Vendor.SearchItem(VEN_Id) Then
    Call cbo_Vendor.AddItem(Array(VEN_Id, VEN_Name), True)
  End If
  If Not cbo_ShipPoint.SearchItem(SHP_Id) Then
    Call cbo_ShipPoint.AddItem(Array(SHP_Id, SHP_Name), True)
  End If
  chk_ASFlag.Value = IIf(IsAsItem, vbChecked, vbUnchecked)
  chk_FreeOfCharge.Value = IIf(IsFree, vbChecked, vbUnchecked)
  Call mo_Tools.EnableControl(txt_Price, chk_FreeOfCharge.Value = vbUnchecked)
  Exit Sub
ErrHandler:
  Call ErrorHandler("DisplayHeader")
End Sub

Private Function ItemCheck() As Boolean
On Error GoTo ErrHandler

Dim lbl_Field As Label
  
  ItemCheck = False
  If mo_Tools.GetComboKey(cbo_ServiceItem) = "" Then
    Set lbl_Field = mo_Tools.GetControl(lbl_Label, "lbl_ServiceItem")
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", lbl_Field.Caption))
    Exit Function
  End If
  If mo_Tools.GetComboKey(cbo_UOM) = DPC_UOM_UNKNOWN Then
    Set lbl_Field = mo_Tools.GetControl(lbl_Label, "lbl_UOM")
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", lbl_Field.Caption))
    Exit Function
  End If
  If mo_Tools.ScreenToDbl(txt_Qty.Text) = 0 Then
    Set lbl_Field = mo_Tools.GetControl(lbl_Label, "lbl_Quantity")
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", lbl_Field.Caption))
    Exit Function
  End If
  If (mo_Tools.ScreenToDbl(txt_Price.Text) = 0) And (chk_FreeOfCharge.Value = vbUnchecked) Then
    Set lbl_Field = mo_Tools.GetControl(lbl_Label, "lbl_Price")
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", lbl_Field.Caption))
    Exit Function
  End If
  If mo_Tools.ScreenToDbl(txt_Cost.Text) = 0 Then
    Set lbl_Field = mo_Tools.GetControl(lbl_Label, "lbl_Cost")
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", lbl_Field.Caption))
    Exit Function
  End If
  If mo_Tools.GetComboKey(cbo_Vendor) = "" Then
    Set lbl_Field = mo_Tools.GetControl(lbl_Label, "lbl_PlantVendor")
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", lbl_Field.Caption))
    Exit Function
  End If
  If mo_Tools.GetComboKey(cbo_ShipPoint) = "" Then
    Set lbl_Field = mo_Tools.GetControl(lbl_Label, "lbl_ShipPoint")
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", lbl_Field.Caption))
    Exit Function
  End If
  If OFD_Pos = 0 Then
    Set lbl_Field = mo_Tools.GetControl(lbl_Label, "lbl_Position")
    Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9701, "#Please, enter mandatory field: $fieldname$", Array("$fieldname$", lbl_Field.Caption))
    Exit Function
  End If
  ItemCheck = True
  Exit Function
ErrHandler:
  Call ErrorHandler("ItemCheck")
End Function

Private Sub btn_Validate_Click()
On Error GoTo ErrHandler
  
  If ItemCheck Then
    Result = True
    Hide
  End If
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Validate_Click")
End Sub

Private Sub btn_Quit_Click()
On Error GoTo ErrHandler
  
  Result = False
  Hide
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Quit_Click")
End Sub

Private Sub cbo_ServiceItem_ComboItemSelected()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  mb_InternalInit = True
  Call mo_Tools.LockScreen(Me, True)
  txt_Code.Text = mo_Tools.GetComboData(cbo_ServiceItem, 2)
  PRD_Code = txt_Code.Text
  Call LoadSystemMargin
  Call mo_Tools.LockScreen(Me, False)
  mb_InternalInit = False
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_ServiceItem_ComboItemSelected")
End Sub

Private Sub chk_FreeOfCharge_Click()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  If chk_FreeOfCharge.Value = vbChecked Then
    Call mo_Tools.EnableControl(txt_Price, False)
    txt_Price.Text = mo_Tools.DblToScreen(0)
    Call txt_Price_Validate(False)
  Else
    Call mo_Tools.EnableControl(txt_Price, True)
  End If
  Exit Sub
ErrHandler:
  Call ErrorMessage("chk_FreeOfCharge_Click")
End Sub

Private Sub txt_OFD_Pos_LostFocus()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  OFD_Pos = mo_Tools.ScreenToLong(txt_OFD_Pos.Text)
  Exit Sub
ErrHandler:
  Call ErrorMessage("txt_OFD_Pos_LostFocus")
End Sub

Private Sub cal_DeliveryDate_datechangee()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  OFD_DelDat = cal_DeliveryDate.date_dt
  Exit Sub
ErrHandler:
  Call ErrorMessage("cal_DeliveryDate_datechangee")
End Sub

Private Sub cal_ShipDate_datechangee()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  OFD_ShpDat = cal_ShipDate.date_dt
  Exit Sub
ErrHandler:
  Call ErrorMessage("cal_ShipDate_datechangee")
End Sub

Private Sub cal_WishDate_datechangee()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  OFD_WshDat = cal_WishDate.date_dt
  Exit Sub
ErrHandler:
  Call ErrorMessage("cal_WishDate_datechangee")
End Sub

Private Sub cbo_Vendor_ComboItemSelected()
On Error GoTo ErrHandler

  If mb_InternalInit Then Exit Sub
  mb_InternalInit = True
  VEN_Id = mo_Tools.GetComboKey(cbo_Vendor)
  VEN_Name = cbo_Vendor.Text
  Call cbo_ShipPoint.Clear
  SHP_Id = 0
  SHP_Name = ""
  Call InitShipPointCombo(cbo_ShipPoint)
  mb_InternalInit = False
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_Vendor_ComboItemSelected")
End Sub

Private Sub cbo_ShipPoint_ComboItemSelected()
On Error GoTo ErrHandler
  
  If mb_InternalInit Then Exit Sub
  SHP_Id = mo_Tools.GetComboKey(cbo_ShipPoint)
  SHP_Name = cbo_ShipPoint.Text
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_ShipPoint_ComboItemSelected")
End Sub

Private Sub txt_Qty_Validate(Cancel As Boolean)
On Error GoTo ErrHandler
  
Dim ll_Decimal As Long
  
  If mb_InternalInit Then Exit Sub
  mb_InternalInit = True
  ll_Decimal = mo_Tools.GetUM_Decimal(mo_Tools.GetComboKey(cbo_UOM), ms_COF_Lang)
  txt_Qty.Text = mo_Tools.DblToScreen(mo_Tools.ScreenToDbl(txt_Qty.Text, ll_Decimal), ll_Decimal)
  txt_Total.Text = mo_Tools.DblToScreen(mo_Tools.ScreenToDbl(txt_Qty.Text) * mo_Tools.ScreenToDbl(txt_Price.Text), 2)
  mb_InternalInit = False
  Exit Sub
ErrHandler:
  Call ErrorMessage("txt_Qty_Validate")
End Sub

Private Sub cbo_UOM_ComboItemSelected()
On Error GoTo ErrHandler
  
Dim ll_Decimal As Long
  
  If mb_InternalInit Then Exit Sub
  mb_InternalInit = True
  ll_Decimal = mo_Tools.GetUM_Decimal(mo_Tools.GetComboKey(cbo_UOM), ms_COF_Lang)
  txt_Qty.Text = mo_Tools.DblToScreen(mo_Tools.ScreenToDbl(txt_Qty.Text, ll_Decimal), ll_Decimal)
  txt_Total.Text = mo_Tools.DblToScreen(mo_Tools.ScreenToDbl(txt_Qty.Text) * mo_Tools.ScreenToDbl(txt_Price.Text), 2)
  mb_InternalInit = False
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_UOM_ComboItemSelected")
End Sub

Private Sub txt_Price_Validate(Cancel As Boolean)
On Error GoTo ErrHandler
  
  If mb_InternalInit Then Exit Sub
  txt_Total.Text = mo_Tools.DblToScreen(mo_Tools.ScreenToDbl(txt_Qty.Text) * mo_Tools.ScreenToDbl(txt_Price.Text), 2)
  Exit Sub
ErrHandler:
  Call ErrorMessage("txt_Price_Validate")
End Sub

Public Function GenerateOfferDetail() As Collection
On Error GoTo ErrHandler

Dim ll_RowIdx As Long
Dim lo_Offer As DPC_OfferPos
Dim lo_Collection As New Collection
Dim ld_Qty As Double, ld_Price As Double, ld_Cost As Double
Dim ll_PU As Long
Dim ll_SetupCounter As Long

  Set lo_Offer = OfferPrice(1)
  
  lo_Offer.COF_Id = COF_Id
  lo_Offer.CAT_Id = eDPCCategory.cgServiceItem
  lo_Offer.DOF_Id = eDPCOfferDetail.odPosition
  lo_Offer.OFD_Type = eDPCPriceBookType.eServiceItem
  lo_Offer.OFD_Pos = OFD_Pos
  lo_Offer.PRD_Code = PRD_Code
  lo_Offer.PRD_Id = mo_Tools.GetComboKey(cbo_ServiceItem)
  If Trim(txt_AddText.Text) = "" Then
  lo_Offer.PRD_Name = cbo_ServiceItem.Text
  Else
    If InStr(1, cbo_ServiceItem.Text, ":") = 0 Then
      lo_Offer.PRD_Name = cbo_ServiceItem.Text & " : " & txt_AddText.Text
    Else
      lo_Offer.PRD_Name = cbo_ServiceItem.Text & " " & txt_AddText.Text
    End If
  End If
  lo_Offer.OFD_Order = 0
  lo_Offer.OFD_Valid = True
  lo_Offer.ERR_Type = eDPCErrorType.etNone
  lo_Offer.LEV_Id = eDPCLevel.lvStandard
  lo_Offer.OFD_Main = eDPCOfferDetailMain.odMain
  
  lo_Offer.SAE_Id = SAE_Id
  lo_Offer.SHP_Id = SHP_Id
  lo_Offer.VEN_Id = VEN_Id
  
  lo_Offer.SAE_Name = SAE_Name
  lo_Offer.SHP_Name = SHP_Name
  lo_Offer.VEN_Name = VEN_Name
  
  lo_Offer.OFD_WshDat = OFD_WshDat
  lo_Offer.OFD_DelDat = OFD_DelDat
  lo_Offer.OFD_ShpDat = OFD_ShpDat
  
  lo_Offer.OFD_IsAsItem = IIf(chk_ASFlag.Value = vbChecked, True, False)
  lo_Offer.OFD_IsFree = IIf(chk_FreeOfCharge.Value = vbChecked, True, False)
  
  ld_Qty = mo_Tools.ScreenToDbl(txt_Qty.Text)
  ll_PU = 1
  ld_Price = mo_Tools.ScreenToDbl(txt_Price.Text)
  ld_Cost = mo_Tools.ScreenToDbl(txt_Cost.Text)
  
  Call lo_Offer.Init(ld_Qty, ld_Qty, eDPCQtyType.qtUnknown, ll_PU, 0, 0)
  lo_Offer.OFD_Disco = 0
  lo_Offer.OFD_MarginS = OFD_MarginS
  lo_Offer.OFD_MarginMin = OFD_MarginMin
  lo_Offer.OFD_GTN = OFD_GTN
  
  lo_Offer.UM_Code = mo_Tools.GetComboKey(cbo_UOM)
  lo_Offer.UM_Name = cbo_UOM.Text
  lo_Offer.OFD_PU = ll_PU
  lo_Offer.OFD_Qty = ld_Qty
  lo_Offer.OFD_QtyA = ld_Qty
  lo_Offer.OFD_Price = ld_Price
  lo_Offer.OFD_PriceA = ld_Price
  lo_Offer.OFD_Cost = ld_Cost
  lo_Offer.OFD_CostA = ld_Cost
  lo_Offer.CURR_Code = CURR_Code
  lo_Offer.OFD_HasPrice = True
  lo_Offer.OFD_HasQty = True
  lo_Offer.OFD_HasTotal = True
  Call lo_Collection.Add(lo_Offer)
  Set GenerateOfferDetail = lo_Collection
  Exit Function
ErrHandler:
  Call ErrorHandler("GenerateOfferDetail")
End Function

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$COF_Lang$", mo_Tools.SQLStr(ms_COF_Lang), , , vbTextCompare)
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

